unit graf_fx;

interface

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////////////////////}

uses crt;

{// M O J E   T Y P Y   D A N Y C H
{///////////////////////////////////////////////////////}

type wielka_tablica = array[0..63999] of byte;

type obraz = record
              szerokosc : word;
              wysokosc : word;
              wsk_obrazu : ^wielka_tablica;
              rozmiar : word;
             end;

type naglowek_pliku_BMP = record
                           typ_obrazu : array[0..1] of char;
                           rozmiar_pliku : longint;
                           zarezerwowane1 : word;
                           zarezerwowane2 : word;
                           odleglosc_do_obrazu : longint;
                           rozmiar_naglowka_info : longint;
                           szerokosc_obrazu : longint;
                           wysokosc_obrazu : longint;
                           liczba_planow_obrazu : word;
                           liczba_bitow_na_piksel : word;
                           typ_kompresji : longint;
                           rozmiar_obrazu : longint;
                           pozioma_rozdziel_DPI : longint;
                           pionowa_rozdziel_DPI : longint;
                           liczba_uzywanych_kolorow : longint;
                           liczba_znaczacych_kolorow : longint;
                          end;

type wzorzec_koloru_BMP = record
                           niebieski : byte;
                           zielony : byte;
                           czerwony : byte;
                           zarezerwowany : byte;
                          end;

type wzorzec_koloru = record
                       czerwony : byte;
                       zielony : byte;
                       niebieski : byte;
                      end;

type prostokat = record
                  x : integer;
                  y : integer;
                  szerokosc : integer;
                  wysokosc : integer;
                 end;

type wzorzec_znaku = array[0..7] of byte;

type paleta_kolorow = array[0..255] of wzorzec_koloru;

type naglowek_WAV = record
                    tab_RIFF : array[0..3] of char;
                    rozmiar_pliku_bez_8 : longint;
                    tab_WAVE : array[0..3] of char;
                    tab_fmt : array[0..3] of char;
                    liczba_bajtow_do_data : longint;
                    format_danych : word;
                    liczba_kanalow : word;
                    czestotliwosc : longint;
                    liczba_bajtow_na_sekunde : longint;
                    liczba_bajtow_na_cykl : word;
                    liczba_bitow_na_probke : word;
                    tab_data : array[0..3] of char;
                    rozmiar_danych_dzwiekowych : longint;
                    end;

type fala_dzwiekowa = record
                       naglowek : naglowek_WAV;
                       wsk_bufora : pointer;
                      end;

{// D E F I N I C J E    Z M I E N N Y C H
{///////////////////////////////////////////////////////}

const g_tab_znakow : array[0..70] of wzorzec_znaku =
      (
       ($00, $00, $00, $00, $00, $08, $00, $00),  {0}{'.'}
       ($18, $24, $24, $24, $24, $18, $00, $00),  {1}{'0'}
       ($18, $28, $08, $08, $08, $3C, $00, $00),  {2}{'1'}
       ($38, $44, $08, $10, $20, $7C, $00, $00),  {3}{'2'}
       ($38, $44, $04, $18, $44, $38, $00, $00),  {4}{'3'}
       ($20, $20, $24, $3E, $04, $04, $00, $00),  {5}{'4'}
       ($3E, $20, $3C, $02, $02, $3C, $00, $00),  {6}{'5'}
       ($1C, $20, $38, $24, $24, $18, $00, $00),  {7}{'6'}
       ($3C, $44, $08, $10, $10, $10, $00, $00),  {8}{'7'}
       ($18, $24, $18, $24, $24, $18, $00, $00),  {9}{'8'}
       ($18, $24, $1C, $04, $04, $18, $00, $00),  {10}{'9'}
       ($18, $24, $24, $7E, $42, $42, $00, $00),  {11}{'A'}
       ($7C, $22, $3C, $22, $22, $7C, $00, $00),  {12}{'B'}
       ($3C, $42, $40, $40, $42, $3C, $00, $00),  {13}{'C'}
       ($7C, $22, $22, $22, $22, $7C, $00, $00),  {14}{'D'}
       ($7E, $22, $38, $20, $22, $7E, $00, $00),  {15}{'E'}
       ($7E, $22, $38, $20, $20, $70, $00, $00),  {16}{'F'}
       ($1C, $22, $20, $26, $22, $1C, $00, $00),  {17}{'G'}
       ($44, $44, $7C, $44, $44, $44, $00, $00),  {18}{'H'}
       ($38, $10, $10, $10, $10, $38, $00, $00),  {19}{'I'}
       ($70, $10, $10, $90, $90, $70, $00, $00),  {20}{'J'}
       ($64, $28, $30, $28, $24, $64, $00, $00),  {21}{'K'}
       ($38, $10, $10, $10, $12, $1E, $00, $00),  {22}{'L'}
       ($22, $36, $2A, $22, $22, $22, $00, $00),  {23}{'M'}
       ($22, $32, $2A, $26, $22, $22, $00, $00),  {24}{'N'}
       ($38, $44, $44, $44, $44, $38, $00, $00),  {25}{'O'}
       ($7C, $22, $3C, $20, $20, $70, $00, $00),  {26}{'P'}
       ($38, $44, $44, $44, $4C, $38, $08, $04),  {27}{'Q'}
       ($7C, $22, $3C, $22, $22, $62, $00, $00),  {28}{'R'}
       ($18, $24, $10, $08, $24, $18, $00, $00),  {29}{'S'}
       ($7F, $49, $08, $08, $08, $1C, $00, $00),  {30}{'T'}
       ($22, $22, $22, $22, $22, $1C, $00, $00),  {31}{'U'}
       ($22, $22, $22, $22, $14, $08, $00, $00),  {32}{'V'}
       ($22, $22, $22, $2A, $36, $22, $00, $00),  {33}{'W'}
       ($22, $14, $08, $14, $22, $22, $00, $00),  {34}{'X'}
       ($22, $22, $14, $08, $08, $1C, $00, $00),  {35}{'Y'}
       ($3E, $22, $04, $08, $12, $3E, $00, $00),  {36}{'Z'}
       ($00, $00, $38, $44, $44, $3E, $00, $00),  {37}{'a'}
       ($20, $20, $3C, $22, $22, $3C, $00, $00),  {38}{'b'}
       ($00, $00, $1C, $20, $20, $1C, $00, $00),  {39}{'c'}
       ($02, $02, $1E, $22, $22, $1E, $00, $00),  {40}{'d'}
       ($00, $1C, $22, $3E, $20, $1C, $00, $00),  {41}{'e'}
       ($18, $24, $20, $70, $20, $20, $00, $00),  {42}{'f'}
       ($00, $00, $1C, $22, $22, $1E, $02, $1C),  {43}{'g'}
       ($20, $20, $3C, $22, $22, $22, $00, $00),  {44}{'h'}
       ($00, $10, $00, $10, $10, $10, $00, $00),  {45}{'i'}
       ($00, $10, $00, $10, $10, $10, $10, $70),  {46}{'j'}
       ($20, $20, $24, $38, $24, $24, $00, $00),  {47}{'k'}
       ($20, $20, $20, $20, $20, $38, $00, $00),  {48}{'l'}
       ($00, $00, $63, $55, $49, $41, $00, $00),  {49}{'m'}
       ($00, $00, $2E, $11, $11, $11, $00, $00),  {50}{'n'}
       ($00, $00, $1C, $22, $22, $1C, $00, $00),  {51}{'o'}
       ($00, $00, $3C, $22, $22, $3C, $20, $20),  {52}{'p'}
       ($00, $00, $1E, $22, $22, $1E, $02, $02),  {53}{'q'}
       ($00, $00, $2C, $12, $10, $10, $00, $00),  {54}{'r'}
       ($00, $3C, $22, $18, $44, $38, $00, $00),  {55}{'s'}
       ($10, $10, $38, $10, $10, $10, $00, $00),  {56}{'t'}
       ($00, $00, $24, $24, $24, $18, $00, $00),  {57}{'u'}
       ($00, $00, $14, $14, $14, $08, $00, $00),  {58}{'v'}
       ($00, $00, $41, $49, $55, $63, $00, $00),  {59}{'w'}
       ($00, $00, $24, $18, $18, $24, $00, $00),  {60}{'x'}
       ($00, $00, $24, $24, $24, $3C, $04, $3C),  {61}{'y'}
       ($00, $00, $3C, $08, $10, $3C, $00, $00),  {62}{'z'}
       ($00, $00, $00, $3C, $00, $00, $00, $00),  {63}{'-'}
       ($00, $00, $10, $38, $10, $00, $00, $00),  {64}{'+'}
       ($00, $00, $00, $00, $00, $10, $10, $20),  {65}{','}
       ($00, $02, $04, $08, $10, $20, $00, $00),  {66}{'/'}
       ($00, $14, $08, $14, $00, $00, $00, $00),  {67}{'*'}
       ($00, $00, $08, $00, $00, $08, $00, $00),  {68}{':'}
       ($00, $00, $3C, $00, $3C, $00, $00, $00),  {69}{'='}
       ($00, $00, $00, $00, $00, $7E, $00, $00)   {70}{'_'}
      );

var
port_2x6 : word;
port_2xA : word;
port_2xC : word;
port_2xE : word;

{// N A G L O W K I  P R O C E D U R  I  F U N K C J I}
{///////////////////////////////////////////////////////}

procedure g_ustaw_tryb_vga(tryb : byte);
procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
procedure g_zamaluj_ekran_13h(kolor : byte);
procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
procedure g_laduj_palete_BMP( szciezka : string);
procedure g_wypelnij_p(var p : prostokat; x, y, s, w : integer);
procedure g_wyswietl_obraz_13h(wsk_buforu : pointer; zrodlo, cel : prostokat; rys : obraz);
procedure g_zwolnij_pam( rys : obraz);
procedure g_wyswietl_obraz_13h_k(wsk_buforu : pointer; zrodlo, cel : prostokat;
                                 rys : obraz; czy_p_kolor : boolean; p_kolor : byte);
procedure g_wyswietl_obraz_13h_k_s(wsk_buforu : pointer; zrodlo, cel : prostokat;
                                   rys : obraz; czy_p_kolor : boolean; p_kolor : byte);
procedure g_pobierz_skan_kod(var kod_scan : byte);
procedure g_powtarzanie_klawiszy( liczba, opoznienie : byte);
procedure g_sys_klawiatura( stan : boolean);
procedure g_pokaz_kursor( status : boolean);
procedure g_pobierz_status_myszy(var lewy, srodkowy, prawy : boolean;
                               var poz_x, poz_y : word);
procedure g_wyswietl_tekst_13h( wsk_bufora : pointer; x, y : word;
                                tekst : string; kolor : byte);
procedure g_ustaw_wzorzec_koloru(nr_wzorca : byte; c, z, n : byte);
procedure g_pobierz_pam_dla_drugiego_bufora(var wsk_bufora : pointer);
procedure g_zwolnij_pam_bufora(var wsk_bufora : pointer);
procedure g_kopiuj_bufor( buf_docelowy, buf_zrodlowy : pointer);
procedure g_czekaj_na_powrot_pionowy;
procedure g_wypelnij_bufor(adres : pointer; kolor : byte);
procedure g_pobierz_palete_VGA(var paleta : paleta_kolorow);
procedure g_pobierz_wzorzec_koloru(nr_wzorca : byte; var wzorzec : wzorzec_koloru);
procedure g_wygas_ekran(przerwa : byte);
procedure g_rozjasnij_ekran(var paleta_k : paleta_kolorow; przerwa : byte);
procedure g_topnienie_ekranu(kolor : byte);
procedure g_zalej_ekran( kolor, przerwa : byte);
function g_zresetuj_SB( baza : byte):boolean;
procedure g_zapisz_do_SB(data : byte);
procedure g_odczytaj_z_SB(var data : byte);
procedure g_wlacz_glosniki;
procedure g_wylacz_glosniki;
procedure g_przestan_odtwarzac;
procedure g_laduj_WAV(var data : fala_dzwiekowa; szciezka : string);
procedure g_zwolnij_pam_w( data : fala_dzwiekowa);
procedure g_odegraj_WAV( fala : fala_dzwiekowa; czestotliwosc: word);


implementation

procedure g_ustaw_tryb_vga(tryb : byte);
begin
asm

mov ah, 00h  {zaladuj 00h do AH - numer funkcji przerwania 10h}
mov al, tryb {zaladuj tryb do AL - numer trybu pracy karty graficznej}
int 10h      {wywolaj przerwanie 10h}

end;
end; {koniec procedury g_ustaw_tryb_vga}

{--------------}

procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
begin
asm

mov ax, y                {zaladuj y do AX}
mov di, ax               {zaladuj AX do DI}
shl ax, 8                {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6                {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax               {dodaj AX do DI}
add di, x                {dodaj x do DI}
mov ax, 0a000h           {zaladuj A000 do AX}
mov es, ax               {zaladuj AX do ES}
mov al, kolor            {zaladuj kolor do AL}
mov byte ptr es:[di], al {zapisz pod adres ES:DI warto rejestru AL}

end;
end; {koniec procedury g_rysuj_piksel_13h}

{--------------}

procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
begin
asm
mov cx, x2        {zaladuj x2 do CX}
sub cx, x1        {odejmij x1 od CX i umiesc wynik w CX}
add cx, 1         {dodaj 1 do CX}
mov ax,y          {zaladuj y do AX}
mov di,ax         {zaladuj AX do DI}
shl ax,8          {przesun bity rejestru AX o 8 pozycji w lewo}
shl di,6          {przesun bity rejestru DI o 6 pozycji w lewo}
add di,ax         {dodaj AX do DI}
add di,x1         {dodaj x do DI}
mov ax,0a000h     {zaladuj A000 do AX}
mov es,ax         {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}
cld               {wyzeruj znacznik kierunku - adresy rosnace}
rep stosb         {zapisz CX razy wartosc rejestru AL do komorek
                   pamieci spod adresu ES:DI}
end;
end; {koniec procedury g_rysuj_pozioma_linia_13h}

{--------------}

procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
begin
asm

mov cx, y2        {zaladuj y2 do CX}
sub cx, y1        {odejmij y1 od CX}
add cx, 1         {dodaj 1 do CX}
mov ax, y1        {zaladuj 1 do AX}
mov di, ax        {zaladuj AX do DI}
shl ax, 8         {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6         {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax        {dodaj AX do DI}
add di, x         {dodaj x do DI}
mov ax, 0a000h    {zaladuj A000 do AX}
mov es, ax        {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}

@rysuj_linie:     {definicja etykiety}
mov es:[di], al   {zapisz AL do komorki pamieci o adresie ES:DI}
add di, 320       {dodaj 320 do DI}
loop @rysuj_linie {zmiejsz CX o 1, jezeli rozny od 0 skocz do etykiety rysuj_linie}

end;
end; {koniec procedury g_rysuj_pionowa_linia_13h}

{--------------}

procedure g_zamaluj_ekran_13h(kolor : byte);
begin
asm

mov ax, 0A000h   {zaladuj A000h do AX}
mov es, ax       {zaladuj AX do ES}
mov di, 0        {zaladuj 0 do DI}
mov cx, 32000    {zaladuj 32000 do CX}
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_zamaluj_ekran_13h}

{--------------}

procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
var
plik : file;
naglowek : naglowek_pliku_BMP;
licznik, wynik : word;
licznik_odczytu : word;
begin

{Skojarzenie zbiory ze zmienna plikowa i otworzenie go}
assign(plik, szciezka);
reset(plik, 1);

{odczyt naglowka bitmapy}
licznik := sizeof(naglowek_pliku_BMP);
blockread(plik, naglowek, licznik, wynik);

{Sprawdzenie czy rozmiary obrazu sa zgodne z rozdzielczoscia ekranu }
if((naglowek.szerokosc_obrazu > 320) or
   (naglowek.wysokosc_obrazu > 200)) then
   begin
   close(plik);   {zamkniecie pliku}
   exit;          {opuszczenie procedury}
   end;  {koniec if then}

{przeskakujemy palete kolorow}
seek(plik,1078);

{zapisanie rozmiarow obrazu i oblicznie rozmiaru bloku pamieci
 potrzebnego do przechowywania obrazu}
z_obraz.szerokosc := naglowek.szerokosc_obrazu;
z_obraz.wysokosc := naglowek.wysokosc_obrazu;
z_obraz.rozmiar := naglowek.szerokosc_obrazu * naglowek.wysokosc_obrazu;

{Sparwdzamy czy system posiada dosc wolen pamieci do przechowywania
 ladowanego obrazu bitmapy, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < z_obraz.rozmiar) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla obrazu}
getmem(z_obraz.wsk_obrazu, z_obraz.rozmiar);

{zaladowanie obrazu - obraz podczas odczytu zostaje odwrucony w pionie}
licznik := naglowek.szerokosc_obrazu;
for licznik_odczytu := 0 to naglowek.wysokosc_obrazu - 1 do
begin
blockread(plik, z_obraz.wsk_obrazu^[(naglowek.wysokosc_obrazu - 1 - licznik_odczytu) * z_obraz.szerokosc], licznik, wynik);
end; {koniec petli for}

{zamkniecie pliku}
close(plik);

end; {koniec procedury g_laduj_BMP_13h}

{--------------}

procedure g_laduj_palete_BMP( szciezka : string);
var
plik : file;
paleta_k : array[0..255] of wzorzec_koloru_BMP;
licznik, wynik : word;
begin

{skojarzenie zmiennej plikowej plik ze zbiorem danych okreslonym
 przez parametr szciezka}
assign(plik, szciezka);

{otwarcie pliku}
reset(plik, 1);

{przesowa wskaznik pozycji pliku na pierwszy bajt palety kolorow}
seek(plik, sizeof(naglowek_pliku_BMP));

{ustalmy liczbe odczytywanych bajtow na rowna rozmiarowi zmiennej pleta_k}
licznik := sizeof(paleta_k);

{odczytanie palety kolorow}
blockread(plik, paleta_k,licznik, wynik);

{zapis palety kolorow do karty vga zaczynamy od pierwszego wzorca koloru}
port[$3c8] := 0;

{petla wysylajaca do portow karty graficznej palete kolorow}
for licznik :=  0 to 255 do
begin
port[$3c9] := paleta_k[licznik].czerwony shr 2;
port[$3c9] := paleta_k[licznik].zielony shr 2;
port[$3c9] := paleta_k[licznik].niebieski shr 2;
end; {koniec petli for}

{zamknij plik}
close(plik);

end; {koniec procedury g_laduj_palete_BMP}

{--------------}

procedure g_wypelnij_p(var p : prostokat; x, y, s, w : integer);
begin

p.x := x;
p.y := y;
p.szerokosc := s;
p.wysokosc := w;

end; {koniec procedury g_wypelnij_p}

{--------------}

procedure g_wyswietl_obraz_13h(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz);
var
licznik_y : word;
start_zrodlo, start_bufor : word;
przeskok_zrodlo : word;
przeskok_bufor : word;
zmiana_x, zmiana_y : word;
_wsk_obrazu : pointer;
_szerokosc : integer;
begin
zmiana_x := 0;
zmiana_y := 0;
_wsk_obrazu := rys.wsk_obrazu;

{obciecie docelowego prostokata obrazu do wymiarow ekranu}

{- nie rysujemy dla prostokata, ktory nie znajdujacego sie w przestrzeni ekranu}
if(cel.x > 319) then exit;
if(cel.y > 199) then exit;
if(cel.x + cel.szerokosc <= 0) then exit;
if(cel.y + cel.wysokosc <= 0) then exit;

{- jezeli wystaje za lewa krawedz ekranu}
if(cel.x < 0) then
begin
cel.szerokosc := cel.szerokosc + cel.x;
zmiana_x := -cel.x;
cel.x := 0;
end;

{- jezeli wystaje za gorna krawedz ekranu}
if(cel.y < 0) then
begin
cel.wysokosc := cel.wysokosc + cel.y;
zmiana_y  := -cel.y;
cel.y := 0;
end;

{- jezeli wystaje za prawa krawedz ekranu}
if( (cel.x + cel.szerokosc) > 319) then cel.szerokosc := 320 - cel.x;

{- jezeli wystaje za dolna krawedz ekranu}
if( (cel.y + cel.wysokosc) > 199) then cel.wysokosc := 200 - cel.y;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + zmiana_x + ((zrodlo.y + zmiana_y) * rys.szerokosc);

{obliczenie przesuniecia w bajtach rysowanego obrazu w buforze ekranu}
start_bufor := cel.x + cel.y * 320;

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := cel.szerokosc;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

_szerokosc := cel.szerokosc;
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}
les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
cld                  {zeruj znacznik kierunku - DF, adresy rosnace}
rep movsb            {kopiowanie bajtow}
pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end; {koniec procedury g_wyswietl_obraz_13h}

{--------------}

procedure g_zwolnij_pam( rys : obraz);
begin

freemem(rys.wsk_obrazu, rys.rozmiar);

end; {koniec procedury g_zwolnij_pam}

{--------------}

procedure g_wyswietl_obraz_13h_k(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz; czy_p_kolor : boolean;
                     p_kolor : byte);
var
licznik_y : word;
start_zrodlo, start_bufor : word;
przeskok_zrodlo : word;
przeskok_bufor : word;
zmiana_x, zmiana_y : word;
_wsk_obrazu : pointer;
_szerokosc : integer;
begin
zmiana_x := 0;
zmiana_y := 0;
_wsk_obrazu := rys.wsk_obrazu;

{obciecie docelowego prostokata obrazu do wymiarow ekranu}

{- nie rysujemy dla prostokata, ktory nie znajdujacego sie w przestrzeni ekranu}
if(cel.x > 319) then exit;
if(cel.y > 199) then exit;
if(cel.x + cel.szerokosc <= 0) then exit;
if(cel.y + cel.wysokosc <= 0) then exit;

{- jezeli wystaje za lewa krawedz ekranu}
if(cel.x < 0) then
begin
cel.szerokosc := cel.szerokosc + cel.x;
zmiana_x := -cel.x;
cel.x := 0;
end;

{- jezeli wystaje za gorna krawedz ekranu}
if(cel.y < 0) then
begin
cel.wysokosc := cel.wysokosc + cel.y;
zmiana_y  := -cel.y;
cel.y := 0;
end;

{- jezeli wystaje za prawa krawedz ekranu}
if( (cel.x + cel.szerokosc) > 319) then cel.szerokosc := 320 - cel.x;

{- jezeli wystaje za dolna krawedz ekranu}
if( (cel.y + cel.wysokosc) > 199) then cel.wysokosc := 200 - cel.y;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + zmiana_x + ((zrodlo.y + zmiana_y) * rys.szerokosc);

{obliczenie przesuniecia w bajtach rysowanego obrazu w buforze ekranu}
start_bufor := cel.x + cel.y * 320;

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := cel.szerokosc;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

_szerokosc := cel.szerokosc;
if (czy_p_kolor = FALSE) then {czy uwzglednic przezroczysty kolor}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}
les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
cld                  {zeruj znacznik kierunku - DF, adresy rosnace}
rep movsb            {kopiowanie bajtow}
pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end else {jesli czy_p_kolor = TRUE}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}

les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
mov ah, p_kolor           {zaladuj p_kolor do AH}

@petla:                   {definicja etykiety petla }
mov al, byte ptr ds:[si]  {zaladuj do AL bajt z pod adresu DS:SI}
cmp al, ah                {porowanaj AL z AH}
jz @przezroczysty         {jezeli AL jest rowne AH to skocz do etykiety przezroczysty}
mov byte ptr es:[di], al  {zapisz pod adres ES:DI wartosc rejestru AL}
@przezroczysty:           {definicja etykiety przezroczysty}
inc di                    {zwieksz DI o 1}
inc si                    {zwieksz SI o 1}
loop @petla               {zmiejsz CX i skocz do etykiety petla}

pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}
end;

end; {koniec procedury g_wyswietl_obraz_13h_k}

{--------------}

procedure g_wyswietl_obraz_13h_k_s(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz; czy_p_kolor : boolean;
                     p_kolor : byte);
var
licznik_y,licznik_x : word;
stosunek_x, stosunek_y : real;
start_zrodlo : real;
start_bufor : word;
z_stosunek_y : real;
przeskok_zrodlo : word;
przeskok_bufor : word;
piksel : byte;
begin
z_stosunek_y := 0;

{zmiejszenie docelowego prostokata obrazu do wymiarow ekranu}
if ((cel.x < 0) or (cel.x > 319)) then exit;
if ((cel.y < 0) or (cel.y > 199)) then exit;

if ((cel.x + cel.szerokosc > 319)) then cel.szerokosc := 320 - cel.x;
if ((cel.y + cel.wysokosc > 199)) then cel.wysokosc := 200 - cel.y;

{obliczenie stosunkow rozdzielczosci zrodlowego prostokata do rozdzielczosci
 prostokata docelowego}
stosunek_x := zrodlo.szerokosc / cel.szerokosc;
stosunek_y := zrodlo.wysokosc / cel.wysokosc;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + (zrodlo.y * rys.szerokosc);

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego w buforze ekranu}
start_bufor := cel.x + (cel.y * 320);

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := 0;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

if (czy_p_kolor = FALSE) then {czy uwzglednic przezroczysty kolor}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu bez
 uwzgledniania przezroczystego koloru}
for licznik_y := 0 to cel.wysokosc - 1 do
begin
for licznik_x := 0 to cel.szerokosc - 1 do
begin

{pobierz piksel z bufora obrazu}
piksel := rys.wsk_obrazu^[trunc(start_zrodlo)];

asm
les di, wsk_buforu        {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor       {dodaj start_bufor do DI}
mov ah, piksel            {zaladuj piksel do AH}
mov byte ptr es:[di], ah  {zaladuj AH do komorki spod adresu ES:DI}
inc start_bufor           {zwieksz o 1 zmienna start_bufor}
end;

{przesowamy sie w prawo rysujac kolejne piksele}
start_zrodlo := start_zrodlo + stosunek_x;

end; {koniec petli for licznik_x}

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
z_stosunek_y := z_stosunek_y + stosunek_y;
if (trunc(z_stosunek_y) >= 1.0) then
begin
start_zrodlo := start_zrodlo + (trunc(z_stosunek_y) * przeskok_zrodlo) - zrodlo.szerokosc;
z_stosunek_y := z_stosunek_y - trunc(z_stosunek_y);
end else start_zrodlo := start_zrodlo - zrodlo.szerokosc;

start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end else {jesli czy_p_kolor = TRUE}
begin

{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu z
 uwzglednieniem przezroczystego koloru}
for licznik_y := 0 to cel.wysokosc - 1 do
begin
for licznik_x := 0 to cel.szerokosc - 1 do
begin

{pobierz piksel z bufora obrazu}
piksel := rys.wsk_obrazu^[trunc(start_zrodlo)];

asm
les di, wsk_buforu        {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor       {dodaj start_bufor do DI}
mov ah, piksel            {zaladuj piksel do AH}
cmp p_kolor, ah           {porownaj p_kolor z AH}
jz @przezroczysty         {jezeli p_kolor = AH to skocz do etykiety przezroczysty}
mov byte ptr es:[di], ah  {zaladuj AH do komorki spod adresu ES:SI}
@przezroczysty:           {definicja etykiety przezroczysty}
inc start_bufor           {zwieksz o 1 zmienna start_bufor}
end;

start_zrodlo := start_zrodlo + stosunek_x;

end; {koniec petli for licznik_x}

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
z_stosunek_y := z_stosunek_y + stosunek_y;
if (trunc(z_stosunek_y) >= 1.0) then
begin
start_zrodlo := start_zrodlo + (trunc(z_stosunek_y) * przeskok_zrodlo) - zrodlo.szerokosc;
z_stosunek_y := z_stosunek_y - trunc(z_stosunek_y);
end else start_zrodlo := start_zrodlo - zrodlo.szerokosc;

start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end; {koniec bloku else}

end; {koniec procedury g_wyswietl_obraz_13h_k_s}

{--------------}

procedure g_pobierz_skan_kod(var kod_scan : byte);
var
temp : byte;
begin

{pobranie informacji o klawiaturze}
temp := port[$64];

{sprawdzenie czy bufor nie jest pusty i czy bajt znajdujacy sie w
 porcie 60h pochodzi od klawiatury, jezeli ktoras z tych dwoch rzeczy sie
 nie zgadza odczytujemy z portu 60h wartosc poto aby go oproznic co pozwoli
 klawiaturze na zapisanie do niego kolejnych informacji, zapisujemy zero do
 otrzymanej poprzez parametr zmiennej i wychodzimy z procedury}
if ((temp and $01) = 0) then
                        begin
                        kod_scan := 0;
                        exit;
                        end;

if ((temp and $20) = 32) then
                        begin
                        temp := port[$60];
                        kod_scan := 0;
                        exit;
                        end;

{pobierz kod scan nacisnietego lub zwolnionego klawisza}
kod_scan := port[$60];

end; {koniec procedury g_pobierz_skan_kod}

{--------------}

procedure g_powtarzanie_klawiszy( liczba, opoznienie : byte);
begin
asm

mov ah, 03h        {laduj 03h do AH, numer funkcji przerwania 16h}
mov bl, liczba     {laduj liczba do BL, liczba powtorzen kodu klawiszy}
mov bh, opoznienie {laduj opoznienie do BH }
int 16h            {wywolaj przerwanie 16h}

end;
end; {koniec procedurey g_powtarzanie_klawiszy}

{--------------}

procedure g_sys_klawiatura( stan : boolean);
begin

if(stan = TRUE) then
   port[$21] := $00    {wlaczenie obslugi przerwania klawiatury}
   else
   port[$21] := $02;   {wylaczenie obslugi przerwania klawiatury}

end; {koniec procedury g_sys_klawiatura}

{--------------}

procedure g_pokaz_kursor( status : boolean);
begin

if (status = TRUE) then
                   asm
                   mov ax, 0001h  {laduj 0001h do AX}
                   int 33h        {wywolaj przerwanie 33h}
                   end else
                   asm
                   mov ax, 0002h  {laduj 0002h do AX}
                   int 33h        {wywolaj przerwanie 33h}
                   end;

end; {koniec procedury g_pokaz_kursor}

{--------------}

procedure g_pobierz_status_myszy(var lewy, srodkowy, prawy : boolean;
                               var poz_x, poz_y : word);
var
temp : word;
temp_poz_x, temp_poz_y : word;
begin

asm
mov ax, 0003h                  {laduj 00003h do AX}
int 33h                        {wywolaj przerwanie 33h}
mov word ptr temp, bx          {laduj BX do temp}
mov word ptr temp_poz_x, cx    {laduj CX do temp_poz_x}
mov word ptr temp_poz_y, dx    {laduj DX do temp_poz_y}
end;

poz_x := temp_poz_x;
poz_y := temp_poz_y;

if ( (temp and $01) <> 0 ) then lewy := TRUE else lewy := FALSE;
if ( (temp and $02) <> 0 ) then prawy := TRUE else prawy := FALSE;
if ( (temp and $04) <> 0 ) then srodkowy := TRUE else srodkowy := FALSE;

end; {koniec procedury g_pobierz_status_myszy}

{--------------}

procedure g_wyswietl_tekst_13h( wsk_bufora : pointer; x, y : word; tekst : string; kolor : byte);
var
liczba_znakow_w_tekscie : byte;
licznik_znakow,licznik_bitow : byte;
licznik_bajtow : byte;
indeks : byte;
przesuniecie : word;
maska_bitowa : byte;
begin

{jezeli tekst lezy za nisko przerywamy prace procedury}
if((y + 8) > 199) then exit;

{obliczmy przesuniecie w buforze do pierwszego piksela tekstu}
przesuniecie := (y * 320) + x;

{pobieramy liczbe znakow w tekscie}
liczba_znakow_w_tekscie := ord(tekst[0]);

{rysujemy wszystkie znaki}
for licznik_znakow := 1 to liczba_znakow_w_tekscie do
begin

{jezeli napotykamy na spacje przechodzimy do kolejnego znaku}
if(tekst[licznik_znakow] = ' ') then
begin
x := x + 8;
if (x > 312) then break;
przesuniecie := (y * 320) + x;
continue;
end else {w przeciwnym wypadku sprawdzamy czy znak jest kropka,
          lub innym znakiem specjalnym}

if(tekst[licznik_znakow] = '.') then indeks := 0 else
if(tekst[licznik_znakow] = '-') then indeks := 63 else
if(tekst[licznik_znakow] = '+') then indeks := 64 else
if(tekst[licznik_znakow] = ',') then indeks := 65 else
if(tekst[licznik_znakow] = '/') then indeks := 66 else
if(tekst[licznik_znakow] = '*') then indeks := 67 else
if(tekst[licznik_znakow] = ':') then indeks := 68 else
if(tekst[licznik_znakow] = '=') then indeks := 69 else
if(tekst[licznik_znakow] = '_') then indeks := 70 else

{jesli nia nie jest, sprawdzamy czy jest cyfra}
if((tekst[licznik_znakow] >= '0') and
   (tekst[licznik_znakow] <= '9')) then
   indeks := ord(tekst[licznik_znakow]) - 47 else

{jesli nie jest cyfra to sprawdzamy czy jego kod pasuje do ktoregos
 ze znakow duzych liter}
if((tekst[licznik_znakow] >= 'A') and
   (tekst[licznik_znakow] <= 'Z')) then
   indeks := ord(tekst[licznik_znakow]) - 54 else

{jesli nie jest duza litera sprawdzamy czy jest mala litera}
if((tekst[licznik_znakow] >= 'a') and
   (tekst[licznik_znakow] <= 'z')) then
   indeks := ord(tekst[licznik_znakow]) - 60 else
begin
{jesli procedura wejdzie do tego bloku kodu oznaczac to bedzie, ze
 aktualnie ropatrywany znak nie jest obslugiwany przez procedure
 g_wyswietl_tekst, w takim wypadku przechodzimy do rozpatrzenia
 kolejnego znaku}
x := x + 8;
if (x > 312) then break;
przesuniecie := (y * 320) + x;
continue;
end;

{maska bitowa sluzaca do sledzenia ustawionych bitow w bajtach wzorca znaku}
maska_bitowa := $80;  {80h = 10000000b}

{malowanie znaku}
for licznik_bajtow := 0 to 7 do
begin
for licznik_bitow := 0 to 7 do
begin
if ((g_tab_znakow[indeks][licznik_bajtow] and maska_bitowa) = maska_bitowa)
 then
asm
les di, wsk_bufora         {laduj adres bufora wideo, segment do ES, offset do DI}
add di, przesuniecie       {dodaj przesuniecie do DI}
mov ah, kolor              {laduj kolor do AH}
mov byte ptr es:[di], ah   {laduj AH do komorki pamieci spod adresu ES:DI}
end;

{przesowamy ustawiony bit maski o jedna pozycje w prawo}
maska_bitowa := maska_bitowa shr 1;

{przechodzimy do kolejnego piksela malowanej lini}
przesuniecie := przesuniecie + 1;

end; {koniec petli for licznik_bitow}

{cofamy sie na poczatek lini i przeskakujemy jedna nizej}
przesuniecie := przesuniecie + 320 - 8;

{odswiezenie maski bitowej}
maska_bitowa := $80;  {80h = 10000000b}

end; {koniec petli for licznik_bajtow}

{ustawienie przesuniecia na pierwszy piksel kolejnego rysowanego znaku,
 przy okazji sprawdzamy czy nastepny znak wyjdzie za prawa krawedz ekranu,
 jesli tak, to przerywamy petle rysujaca znaki}
x := x + 8;
if (x > 312) then break;  {przerwanie petli for licznik_znakow}
przesuniecie := (y * 320) + x;

end; {koniec petli for licznik znakow}

end; {koniec procedury g_wyswietl_tekst_13h}

{--------------}

procedure g_ustaw_wzorzec_koloru(nr_wzorca : byte; c, z, n : byte);
begin

{okreslamy numer wzorca koloru ktory chcemy zmodyfikowac}
port[$3c8] := nr_wzorca;

{wysylamy do portu 3c9h intensywnosc podstawowych kolorow}
port[$3c9] := c;
port[$3c9] := z;
port[$3c9] := n;

end; { koniec procedury g_ustaw_wzorzec_koloru}

{--------------}

procedure g_pobierz_pam_dla_drugiego_bufora(var wsk_bufora : pointer);
var
wolna_pamiec : longint;
begin

{sprawdzamy czy system posiada wystarczajaco duzo wolnej pamieci}
wolna_pamiec := maxavail;
if(wolna_pamiec < 64000) then exit;

{pobranie pamieci}
getmem(wsk_bufora, 64000);

end; {koniec procedury g_pobierz_pam_dla_drugiego_bufora}

{--------------}

procedure g_zwolnij_pam_bufora(var wsk_bufora : pointer);
begin

freemem(wsk_bufora, 64000);

end; {koniec procedury g_zwolnij_pam_bufora}

{--------------}

procedure g_kopiuj_bufor( buf_docelowy, buf_zrodlowy : pointer);
begin
asm

push ds               {odluz na stos wartosc z DS}
lds si, buf_zrodlowy  {laduj adres bufora zrodlowego, segment do DS,
                       offset do SI}
les di, buf_docelowy  {laduj adres bufora docelowego, segment do ES,
                       offset do DI}
mov cx, 32000         {laduj liczbe 32000 do CX, liczba powturzen
                       instrukcji movsw}
cld                   {zeruj znacznik kierunku - adresy rosnace}

rep movsw             {kopiuj dwa bajty spod adresu DS:SI do miejsca
                       w pamieci okreslonego przez adres ES:DI}

pop ds                {laduj wartosc ze stosu do DS}

end;
end; {koniec procedury g_kopiuj_bufor}

{--------------}

procedure g_czekaj_na_powrot_pionowy;
begin
asm

  mov dx, 3dah           {laduj 3DAh do DX}

@trwa_powrot:            {definicja etykiety trwa_powrot}
  in  al, dx             {laduj do AL wartosc z portu 3DAh}
  test al, 00001000b     {sprawdzenie 3-go bitu AL}
  jnz @trwa_powrot       {jezeli wynik testu jest nie zerowy, oznacza
                          to trwanie powrotu pionowego i skok do etykiety
                          trwa_powrot}

@nie_ma_powrotu:          {definicja etykiety nie_ma_powrotu}
  in al, dx               {laduj do AL wartosc z portu 3DAh}
  test al, 00001000b      {sprawdzenie 3-go bitu AL}
  jz @nie_ma_powrotu      {jezeli wynik testu jest zerem, oznacza to brak
                           powrotu pionowego i skok do etykiety
                           nie_ma_powrotu}

end;
end; {koniec procedury g_czekaj_na_powrot_pionowy}

{--------------}

procedure g_wypelnij_bufor(adres : pointer; kolor : byte);
begin
asm

les di, adres    {laduj adres bufora, segment do ES, offset do DI}
mov cx, 32000    {zaladuj 32000 do CX}
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_wypelnij_bufor}

{--------------}

procedure g_pobierz_palete_VGA(var paleta : paleta_kolorow);
var
licznik : byte;
begin

{checmy odczytac cala palete kolorow, dlatego tez ropoczynamy
 jej czytanie od pierwszego wzorca koloru}
port[$3c7] := 0;

{odczytanie palety kolorow}
for licznik := 0 to 255 do
begin

paleta[licznik].czerwony := port[$3c9];
paleta[licznik].zielony := port[$3c9];
paleta[licznik].niebieski := port[$3c9];

end; {koniec petli for}

end; {koniec procedury g_pobierz_palete_VGA}

{--------------}

procedure g_pobierz_wzorzec_koloru(nr_wzorca : byte; var wzorzec : wzorzec_koloru);
begin

{okreslamy numer wzorca koloru ktory chcemy pobrac}
port[$3c7] := nr_wzorca;

{pobieramy z portu 3c9h intensywnosc podstawowych kolorow}
wzorzec.czerwony  := port[$3c9];
wzorzec.zielony   := port[$3c9];
wzorzec.niebieski := port[$3c9];

end; { koniec procedury g_pobierz_wzorzec_koloru}

{--------------}

procedure g_wygas_ekran(przerwa : byte);
var
licznik1, licznik2 : byte;
wzorzec : wzorzec_koloru;
begin

for licznik2 := 0 to 63 do
begin

g_czekaj_na_powrot_pionowy;
{zmiejszamy wartosc kazdego pola intensywnosci barwy o 1}
for licznik1 := 0 to 255 do
begin

g_pobierz_wzorzec_koloru(licznik1, wzorzec);

if(wzorzec.czerwony > 0) then dec(wzorzec.czerwony);
if(wzorzec.zielony > 0) then dec(wzorzec.zielony);
if(wzorzec.niebieski > 0) then dec(wzorzec.niebieski);

g_ustaw_wzorzec_koloru(licznik1, wzorzec.czerwony,
                      wzorzec.zielony, wzorzec.niebieski);

end; {koniec petli for licznik1}

if(przerwa <> 0) then delay(przerwa);
end; {koniec petli for licznik2}

end; {koniec procedury g_wygas_ekran}

{--------------}

procedure g_rozjasnij_ekran(var paleta_k : paleta_kolorow; przerwa : byte);
var
licznik1, licznik2 : byte;
wzorzec : wzorzec_koloru;
begin

for licznik2 := 0 to 63 do
begin

g_czekaj_na_powrot_pionowy;

{zwiekszamy wartosc kazdego pola intensywnosci barwy o 1}
for licznik1 := 0 to 255 do
begin

g_pobierz_wzorzec_koloru(licznik1, wzorzec);

if(wzorzec.czerwony < paleta_k[licznik1].czerwony) then
   inc(wzorzec.czerwony);

if(wzorzec.zielony < paleta_k[licznik1].zielony) then
   inc(wzorzec.zielony);

if(wzorzec.niebieski < paleta_k[licznik1].niebieski) then
   inc(wzorzec.niebieski);

g_ustaw_wzorzec_koloru(licznik1, wzorzec.czerwony,
                      wzorzec.zielony, wzorzec.niebieski);

end; {koniec petli for licznik1}


if(przerwa <> 0) then delay(przerwa);
end; {koniec petli for licznik2}

end; {koniec procedury g_rozjasnij_ekran}

{--------------}

procedure g_topnienie_ekranu(kolor : byte);
var
licznik : longint;
begin

for licznik := 0 to 800000 do
     begin
     g_rysuj_piksel_13h(random(320), random(200), kolor);
     if((licznik mod 10000) = 0) then delay(2);
     end;


end; {koniec procedury g_topnienie_ekranu}

{--------------}

procedure g_zalej_ekran( kolor, przerwa : byte);
var
poz_y_linii : array[0..319] of byte;
rozmiar_fragmentow : array[0..319] of byte;
licznik1, licznik2 : word;
begin

{ustalmy poczatek wszystkich linii na 0 oraz losowo wybieramy predkosc
 malowania kazdej z linii}
for licznik1 := 0 to 319 do
begin
poz_y_linii[licznik1] := 0;
rozmiar_fragmentow[licznik1] := random(7) + 2;
end; {koniec petli for licznik1}

{rysowanie linii}
for licznik1 := 0 to 99 do
begin
for licznik2 := 0 to 319 do
begin

if(poz_y_linii[licznik2] + rozmiar_fragmentow[licznik2] < 200) then
 begin
  g_rysuj_pionowa_linia_13h(licznik2,
                            poz_y_linii[licznik2],
                            poz_y_linii[licznik2] +
                            rozmiar_fragmentow[licznik2],
                            kolor);
  inc(poz_y_linii[licznik2], rozmiar_fragmentow[licznik2]);
 end else {koniec bloku if}
 begin
  g_rysuj_pionowa_linia_13h(licznik2,
                            poz_y_linii[licznik2],
                            199,
                            kolor);
 end; {koniec bloku else}

end; {koniec petli for licznik2}

if(przerwa <> 0) then delay(przerwa);
end; {koniec petli for licznik1}

end; {koniec procedury g_zalej_ekran}

{--------------}

function g_zresetuj_SB( baza : byte):boolean;
begin

baza := baza shl 4;

port_2x6 := $206 + baza;
port_2xA := $20A + baza;
port_2xC := $20C + baza;
port_2xE := $20E + baza;

port[port_2x6] := 1;
delay(5);
port[port_2x6] := 0;
delay(5);

if ((port[port_2xE] and 128 = 128) and (port[port_2xA] = $AA)) then
     g_zresetuj_SB := TRUE else
     g_zresetuj_SB := FALSE;

end; {koniec funkcji g_zresetuj_SB}

{--------------}

procedure g_zapisz_do_SB(data : byte);
begin

{jezli 7 bit portu 2xCh jest ustawiony wykonujemy pusta instrukcje -> ';'}
while (port[port_2xC] and 128 = 128) do ;

{wprowadzenie wartosci do karty dzwiekowej}
port[port_2xC] := data;

end; {koniec procedury g_zapisz_do_SB}

{--------------}

procedure g_odczytaj_z_SB(var data : byte);
begin

{jezli 7 bit portu 2xEh jest wyzerowany wykonujemy pusta instrukcje -> ';'}
while (port[port_2xE] and 128 = 0) do ;

{pobranie wartosci z karty dzwiekowej}
data := port[port_2xA];

end; {koniec procedury g_odczytaj_z_SB}

{--------------}

procedure g_wlacz_glosniki;
begin

g_zapisz_do_SB($D1);

end; {koniec procedury g_wlacz_glosniki}

{--------------}

procedure g_wylacz_glosniki;
begin

g_zapisz_do_SB($D3);

end; {koniec procedury g_wylacz_glosniki}

{--------------}

procedure g_przestan_odtwarzac;
begin

g_zapisz_do_SB($D0);

end; {koniec procedury g_przestan_odtwarzac}

{--------------}

procedure g_laduj_WAV(var data : fala_dzwiekowa; szciezka : string);
var
plik : file;
licznik, wynik : word;
licznik2 : word;
begin

assign(plik, szciezka);
reset(plik, 1);
licznik := sizeof(naglowek_WAV);

{odczytanie naglowka pliku - 44 bajty}
blockread(plik, data.naglowek, licznik, wynik);

{sparwdzamy czy system posiada dosc wolnej pamieci do przechowywania
 ladowanych danych dzwiekowych, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < data.naglowek.rozmiar_danych_dzwiekowych) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla bufora danych opisujacych fale dzwiekowa}
getmem(data.wsk_bufora, data.naglowek.rozmiar_danych_dzwiekowych);

{odczytanie danych dwiekowych}
licznik := data.naglowek.rozmiar_danych_dzwiekowych;
blockread(plik, data.wsk_bufora^, licznik, wynik);

{zakniecie pliku}
close(plik);

end; {koniec procedury g_laduj_WAV}

{--------------}

procedure g_zwolnij_pam_w( data : fala_dzwiekowa);
begin

{zwolnienie pamieci}
freemem(data.wsk_bufora, data.naglowek.rozmiar_danych_dzwiekowych);

end; {koniec procedury g_zwolnij_pam_w}

{--------------}

procedure g_odegraj_WAV( fala : fala_dzwiekowa; czestotliwosc: word);
var
stala_czasowa: byte;
adres, strona: Word;
rozmiar : word;
begin

  { obliczenie adresu i strony bufora dzwiekowego}
  adres  := seg(fala.wsk_bufora^) shl 4 + ofs(fala.wsk_bufora^);
  strona := (seg(fala.wsk_bufora^) + ofs(fala.wsk_bufora^) shr 4) shr 12;

  {przepisanie rozmiaru bufora dzwiekowego do zmiennej dwubajtowej}
  rozmiar := fala.naglowek.rozmiar_danych_dzwiekowych;

  {uruchomienie przeplywu danych z bufora dzwienkowego poprzez kanal
   DMA numer 1 do karty dzwiekowej}

  {blokujemy kanal numer 1}
  port[$00A] := $05;

  {ustalmy tryb transmisji danych przez kontroler DMA na "S", brak
  samoprogramowania, odczyt z pamieci, adresy rosnace}
  port[$00B] := $49;

  {podajmy strone bufora dzwiekowego}
  port[$083] := strona;

  {zerujemy przerzutnik, przed zapisem wartosci dwubajtowej}
  port[$00C] := 00;

  {poadajemy kontrolerowi DMA adres bufora dzwiekowego}
  port[$002] := lo(adres);
  port[$002] := hi(adres);

  {zerujemy przezrzutnik przez zapisem kolejnem wartosci dwubajtowej}
  port[$00C] := 00;

  {podajemy kontrolerowi liczbe bajtow jaka ma przeslac}
  port[$003] := lo(rozmiar);
  port[$003] := hi(rozmiar);

  {odblokowanie kanalu DMA numer 1  - ropoczecie transmisji danych}
  port[$00A] := $01;

  {obliczenie i ustawienie czestotliwosci odtwarzania dzwieku dla
   karty dzwiekowej }
  stala_czasowa := 256 - (1000000 div czestotliwosc);
  g_zapisz_do_SB($40);
  g_zapisz_do_SB(stala_czasowa);

  {ustalenie typu sampli i ich liczby}
  g_zapisz_do_SB($14);
  g_zapisz_do_SB(lo(rozmiar));
  g_zapisz_do_SB(hi(rozmiar));

end; {koniec procedury g_odegraj_WAV}

end. {koniec modulu}

